"""

"""

# Created by Wenjie Du <wenjay.du@gmail.com>
# Updated by Yiyuan Yang <yiyuan.yang@cs.ox.ac.uk>
# License: BSD-3-Clause

ItalyAir = {
   'MICN': {
      'n_steps': 12, 
      'n_features': 13, 
      'epochs': 100, 
      'patience': 10, 
      'n_layers': 1, 
      'd_model': 128, 
      'conv_kernel': [2, 4], 
      'dropout': 0.2, 
      'lr': 0.0034716100317047434
   },
   'MRNN': {
      'n_steps': 12, 
      'n_features': 13, 
      'patience': 10, 
      'epochs': 100, 
      'rnn_hidden_size': 256, 
      'lr': 0.004580922381908652
   },
   'FiLM': {
      'n_steps': 12, 
      'n_features': 13, 
      'epochs': 100, 
      'patience': 10, 
      'window_size': [2], 
      'multiscale': [1, 2], 
      'modes1': 32, 
      'dropout': 0.2, 
      'mode_type': 0, 
      'd_model': 1024, 
      'lr': 0.008798844624398703
   },
   'Pyraformer': {
      'n_steps': 12,
      'n_features': 13,
      'epochs': 100,
      'patience': 10,
      'n_layers': 2,
      'd_model': 1024,
      'd_ffn': 512,
      'n_heads': 2,
      'window_size': [2, 2],
      'inner_size': 5,
      'dropout': 0,
      'attn_dropout': 0.2,
      'lr': 6.800863288381777e-05
   },
   'SCINet': {
      'n_steps': 12,
      'n_features': 13, 
      'epochs': 100, 
      'patience': 10,
      'n_stacks': 1,
      'n_levels': 1, 
      'n_groups': 1, 
      'n_decoder_layers': 2, 
      'd_hidden': 64,
      'dropout': 0.2, 
      'lr': 0.003844808385012784
   },
   'NonstationaryTransformer': {
      'n_steps': 12, 
      'n_features': 13, 
      'epochs': 100, 
      'patience': 10, 
      'n_layers': 1, 
      'd_model': 1024, 
      'n_heads': 2, 
      'd_ffn': 2048, 
      'n_projector_hidden_layers': 2,
      'd_projector_hidden': [32, 32], 
      'dropout': 0.1, 
      'lr': 0.0001181332906931502
   },
   'SAITS': {
      'n_steps': 12,
      'n_features': 13,
      'epochs': 100,
      'patience': 10,
      'n_layers': 3,
      'd_model': 64,
      'd_ffn': 64,
      'n_heads': 8,
      'd_k': 128,
      'd_v': 32,
      'dropout': 0.1,
      'attn_dropout': 0.2,
      'lr': 7.565260478606772e-05
   },
   'BRITS': {
      'n_steps': 12,
      'n_features': 13, 
      'patience': 10, 
      'epochs': 100,
      'rnn_hidden_size': 256,
      'lr': 0.002656655600651736
   },
   'ETSformer': {
      'n_steps': 12,
      'n_features': 13,
      'epochs': 100, 
      'patience': 10, 
      'n_e_layers': 3,
      'n_d_layers': 2, 
      'd_model': 1024, 
      'd_ffn': 256, 
      'n_heads': 8, 
      'top_k': 3, 
      'dropout': 0.1, 
      'lr': 0.0008593150453026654
   },
   'FreTS': {
      'n_steps': 12, 
      'n_features': 13, 
      'epochs': 100,
      'patience': 10,
      'embed_size': 256, 
      'hidden_size': 128,
      'channel_independence': True,
      'lr': 0.004113346745377581
   },
   'USGAN': {
      'n_steps': 12, 
      'n_features': 13, 
      'patience': 10, 
      'epochs': 100, 
      'lr': 0.003388614629153981, 
      'rnn_hidden_size': 512, 
      'dropout': 0.4
   },
   'Transformer': {
      'n_steps': 12, 
      'n_features': 13, 
      'epochs': 100, 
      'patience': 10, 
      'n_layers': 4, 
      'd_model': 256, 
      'd_ffn': 128, 
      'n_heads': 2,
      'd_k': 256, 
      'd_v': 256, 
      'dropout': 0, 
      'attn_dropout': 0.4,
      'lr': 0.0001413262167249848
   },
   'Autoformer': {
      'n_steps': 12, 
      'n_features': 13, 
      'epochs': 100,
      'patience': 10, 
      'n_layers': 3, 
      'd_model': 256,
      'd_ffn': 128, 
      'n_heads': 8, 
      'factor': 3, 
      'moving_avg_window_size': 25,
      'dropout': 0, 
      'lr': 0.0009529974134372709
   },
   'Crossformer': {
      'n_steps': 12,
      'n_features': 13,
      'epochs': 100,
      'patience': 10,
      'n_layers': 2,
      'd_model': 256,
      'd_ffn': 512, 
      'n_heads': 8, 
      'factor': 1,
      'seg_len': 6, 
      'win_size': 2,
      'dropout': 0.2,
      'lr': 0.0007645401186195385
   },
   'Informer': {
      'n_steps': 12, 
      'n_features': 13, 
      'epochs': 100, 
      'patience': 10, 
      'n_layers': 2, 
      'd_model': 1024,
      'd_ffn': 512,
      'n_heads': 1, 
      'factor': 3, 
      'dropout': 0, 
      'lr': 0.00011272326491224963
   },
   'DLinear': {
      'n_steps': 12,
      'n_features': 13,
      'epochs': 100,
      'patience': 10,
      'moving_avg_window_size': 5,
      'd_model': 64,
      'lr': 0.0025169907448697876
   },
   'GRUD': {
      'n_steps': 12, 
      'n_features': 13,
      'epochs': 100, 
      'patience': 10, 
      'rnn_hidden_size': 128,
      'lr': 0.005637211820454757
   },
   'StemGNN': {
      'n_steps': 12,
      'n_features': 13,
      'epochs': 100, 
      'patience': 10, 
      'n_layers': 2, 
      'n_stacks': 1, 
      'd_model': 512,
      'dropout': 0.3, 
      'lr': 0.00526615473656503
   },
   'iTransformer': {
      'n_steps': 12, 
      'n_features': 13,
      'epochs': 100, 
      'patience': 10, 
      'n_layers': 6, 
      'd_model': 256,
      'd_ffn': 256, 
      'n_heads': 4, 
      'd_k': 256,
      'd_v': 64, 
      'dropout': 0,
      'attn_dropout': 0, 
      'lr': 0.0001297673399859578
   },
   'Koopa': {
      'n_steps': 12,
      'n_features': 13,
      'epochs': 100,
      'patience': 10,
      'n_seg_steps': 2,
      'd_dynamic': 128,
      'd_hidden': 512,
      'n_hidden_layers': 3,
      'n_blocks': 3,
      'lr': 0.004009747750371399
   },
   'TimesNet': {
      'n_steps': 12, 
      'n_features': 13, 
      'patience': 10, 
      'epochs': 100, 
      'n_layers': 1, 
      'top_k': 1, 
      'd_model': 512,
      'd_ffn': 256, 
      'n_kernels': 4,
      'dropout': 0.2,
      'lr': 0.00017204495706138635
   },
   'GPVAE': {
      'n_steps': 12, 
      'n_features': 13,
      'latent_size': 7, 
      'patience': 10,
      'epochs': 100, 
      'lr': 0.0027439821888071963,
      'beta': 0.2,
      'sigma': 1.005,
      'length_scale': 7,
      'encoder_sizes': [256, 256],
      'decoder_sizes': [128, 128],
      'window_size': 12
   },
   'PatchTST': {
      'n_steps': 12, 
      'n_features': 13,
      'epochs': 100,
      'patience': 10,
      'patch_len': 8,
      'stride': 4,
      'n_layers': 2,
      'd_model': 64, 
      'd_ffn': 64,
      'n_heads': 4, 
      'd_k': 256, 
      'd_v': 32, 
      'dropout': 0.1,
      'attn_dropout': 0.4, 
      'lr': 0.00012201756611465646
   },
   'CSDI': {
      'n_steps': 12,
      'n_features': 13,
      'patience': 10,
      'epochs': 100,
      'n_layers': 3,
      'n_heads': 16,
      'n_channels': 128,
      'd_time_embedding': 256,
      'd_feature_embedding': 8,
      'd_diffusion_embedding': 32,
      'lr': 0.000722830003844826
   },
}
